#include "Zahl.h"
#include <iomanip>
#include <bitset>
#include <iostream>
#include <iosfwd>

///////////////////////////////////////////////////////////

Zahl::Zahl(const char* string, Basis basis)
     :m_basis(basis), m_string(string)
{
}

///////////////////////////////////////////////////////////

Zahl::Zahl(double d)
     :m_basis(Decimal)
{
    std::stringstream stream;
    stream << std::setprecision(16);
    stream << d;
    stream >> m_string;
}

///////////////////////////////////////////////////////////

Zahl::Zahl(long l)
     :m_basis(Decimal)
{
    std::stringstream stream;
    stream << l;
    stream >> m_string;
}

///////////////////////////////////////////////////////////

Zahl& Zahl::operator =(const Zahl& z)
{
    m_string = z.m_string;
    m_basis = z.m_basis;

    return *this;
}

///////////////////////////////////////////////////////////

Zahl& Zahl::operator =(long l)
{
    m_basis = Decimal;
    std::stringstream stream;
    stream << l;
    stream >> m_string;

    return *this;
}

///////////////////////////////////////////////////////////

Zahl& Zahl::operator =(double d)
{
    m_basis = Decimal;
    std::stringstream stream;
    stream << d;
    stream >> m_string;

    return *this;
}

///////////////////////////////////////////////////////////

long Zahl::ToLong()
{
    std::stringstream stream;
    stream << std::setbase(m_basis);
    stream << m_string;
    long result;
    stream >> result;

    return result;
}

///////////////////////////////////////////////////////////

const char* Zahl::ToString()
{
    return m_string.c_str();
}

///////////////////////////////////////////////////////////

const char* Zahl::ToString(Basis basis)
{
    return TransformTo(basis);
}

///////////////////////////////////////////////////////////

double Zahl::ToDouble()
{
    std::stringstream stream;
    stream << std::setbase(m_basis);
    stream << std::setprecision(16);
    stream << m_string;

    double d;
 
    if(Decimal == m_basis)
    {
        stream >> d;
    }
    else
    {
        int t;
        stream >> t;
        d = t;
    }

    return d;
}

///////////////////////////////////////////////////////////

const char* Zahl::TransformTo(Basis basis)
{
    std::stringstream stream;
  
    double d = ToDouble();

    if(Decimal == basis)
    {
        stream << std::setbase(Decimal);
        stream << d;
        
        m_string = stream.str();
    }
    else if(Binaer == basis)
    {
        int t = (int)d;
        std::bitset<32> bits(t);

        m_string = bits.to_string<char, std::char_traits<char>, std::allocator<char> >();
    }
    else
    {
        int t = (int)d;
        stream << std::setbase(basis);
        stream << t;

        m_string = stream.str();
    }
    
    return m_string.c_str();
}

///////////////////////////////////////////////////////////




