// Faecher.cpp: implementation of the CFaecher class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Notenverwaltung.h"

#pragma warning (disable : 4786)

#include "Faecher.h"
#include "Fach.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

IMPLEMENT_SERIAL(CFaecher, CObject, 1)

CFaecher::CFaecher()
{

}

CFaecher::~CFaecher()
{
    Faecher::iterator it = _faecher.begin();
    Faecher::iterator end = _faecher.end();
    for( ; it != end; ++it)
    {
        CFach* fach = it->second;
        delete fach;
    }
}

void CFaecher::Serialize(CArchive& ar)
{
    if(ar.IsStoring())
    {
        int anzahl = _faecher.size();
        ar << anzahl;
        Faecher::iterator it = _faecher.begin();
        Faecher::iterator end = _faecher.end();
        for( ; it != end; ++it)
        {
            CString name = it->first;
            CFach* aktuellesFach = it->second;
            ar << name;
            aktuellesFach->Serialize(ar);
        }
    }
    else
    {
        int anzahl = 0;
        ar >> anzahl;
        for(int i = 0; i < anzahl; ++i)
        {
            CString name;
            ar >> name;
            CFach* fach = new CFach;
            fach->Serialize(ar);
            _faecher[name] = fach;
        }
    }
}


CFach& CFaecher::neuesFach(const CString& name, 
                                                const CString& lehrername)
{
    CFach* fach = 0;

    Faecher::iterator it = _faecher.find(name);
    if(_faecher.end() != it)
    {
        fach = it->second;
    }
    else
    {
        fach = new CFach(lehrername);
        _faecher[name] = fach;
    }
    return *fach;
}

void CFaecher::fillFachArray(CStringArray& fachnamen)
{
    Faecher::const_iterator it = _faecher.begin();
    Faecher::const_iterator end = _faecher.end();
    for( ; it != end; ++it)
    {
        fachnamen.Add(it->first);
    }
}