// LeftView.cpp : implementation of the CLeftView class
//

#include "stdafx.h"
#include "Notenverwaltung.h"

#include "NotenverwaltungDoc.h"
#include "LeftView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLeftView

IMPLEMENT_DYNCREATE(CLeftView, CTreeView)

BEGIN_MESSAGE_MAP(CLeftView, CTreeView)
	//{{AFX_MSG_MAP(CLeftView)
	ON_WM_CONTEXTMENU()
	ON_NOTIFY_REFLECT(NM_RCLICK, OnRclick)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CTreeView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CTreeView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CTreeView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLeftView construction/destruction

CLeftView::CLeftView()
{
}

CLeftView::~CLeftView()
{
}

BOOL CLeftView::PreCreateWindow(CREATESTRUCT& cs)
{
	return CTreeView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CLeftView drawing

void CLeftView::OnDraw(CDC* pDC)
{
	CNotenverwaltungDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
}


/////////////////////////////////////////////////////////////////////////////
// CLeftView printing

BOOL CLeftView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CLeftView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
}

void CLeftView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
}

void CLeftView::OnInitialUpdate()
{
	CTreeView::OnInitialUpdate();
    LONG style = GetWindowLong(m_hWnd, GWL_STYLE);
    style = style | TVS_HASBUTTONS | TVS_LINESATROOT | TVS_SHOWSELALWAYS;
    SetWindowLong(m_hWnd, GWL_STYLE, style);
}

/////////////////////////////////////////////////////////////////////////////
// CLeftView diagnostics

#ifdef _DEBUG
void CLeftView::AssertValid() const
{
	CTreeView::AssertValid();
}

void CLeftView::Dump(CDumpContext& dc) const
{
	CTreeView::Dump(dc);
}

CNotenverwaltungDoc* CLeftView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CNotenverwaltungDoc)));
	return (CNotenverwaltungDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CLeftView message handlers

void CLeftView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
    // Zugriff auf das Tree Control
    CTreeCtrl& treeCtrl = GetTreeCtrl();
    // Alle Elemente lschen
    treeCtrl.DeleteAllItems();
    HTREEITEM root = treeCtrl.InsertItem("Notenverwaltung");

    // Zeiger auf das Document holen
    CNotenverwaltungDoc* doc = GetDocument();
    CStringArray fachnamen;
    doc->fillFachArray(fachnamen);

    CString aktuellesFach = doc->getAktuellesFach();

    for(int i = 0; i < fachnamen.GetSize(); ++i)
    {
        CString fachname = fachnamen[i];
        HTREEITEM item = treeCtrl.InsertItem(fachname , root);
        if(fachname == aktuellesFach)
        {
            treeCtrl.SelectItem(item);
        }
    }
    treeCtrl.Expand(root, TVE_EXPAND);
}

void CLeftView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	// TODO: Add your message handler code here
	
}

void CLeftView::OnRclick(NMHDR* pNMHDR, LRESULT* pResult) 
{
    CPoint point;
    GetCursorPos(&point);

    CPoint clientPoint(point);
    ScreenToClient(&clientPoint);

    CTreeCtrl& treeCtrl = GetTreeCtrl();
    HTREEITEM root = treeCtrl.GetRootItem();

    HTREEITEM hit = treeCtrl.HitTest(clientPoint);

    if(hit == root)
    {
        CMenu menu;
        if (menu.LoadMenu(IDR_FACHCONTEXT))
        {
            CMenu* pPopup = menu.GetSubMenu(0);
            ASSERT(pPopup != NULL);
        
            pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
                point.x, point.y,
                AfxGetMainWnd()); // use main window for cmds
        }
    }
    	
	*pResult = 0;
}
