
#include "Kreis.h"

///////////////////////////////////////////////////////////

Kreis::Kreis(long x, long y, long radius)
      :m_x(x),  // Initialisierung
	   m_y(y),  // mit Initialisierungsliste
	   m_radius(radius),
	   m_farbe(RGB(10,10,10))
{
}

///////////////////////////////////////////////////////////

void Kreis::setzeFarbe(COLORREF farbe)
{
	m_farbe = farbe;

	if(m_kreis != 0)
	{
		try
		{
			m_kreis->Farbe = m_farbe;
		}
		catch(_com_error&)
		{
		}
	}
}

///////////////////////////////////////////////////////////

void Kreis::setzeKoordinaten(long x, long y)
{
	m_x = x;
	m_y = y;

	if(m_kreis != 0)
	{
		try
		{
			m_kreis->X = m_x;
			m_kreis->Y = m_y;
		}
		catch(_com_error&)
		{
		}
	}
}

///////////////////////////////////////////////////////////

void Kreis::setzePointer(const TSUZEICHNENLib::IKreisPtr& ptr)
{
	m_kreis = ptr;

	if(m_kreis != 0)
	{
		m_kreis->Farbe = m_farbe;
		m_kreis->Radius = m_radius;
		m_kreis->X = m_x;
		m_kreis->Y = m_y;
	}
}

///////////////////////////////////////////////////////////

void Kreis::setzeRadius(long radius)
{
	m_radius = radius;

	if(m_kreis != 0)
	{
		try
		{
			m_kreis->Radius = m_radius;
		}
		catch(_com_error&)
		{
		}
	}
}

///////////////////////////////////////////////////////////
